/*
 * Decompiled with CFR 0.152.
 */
package com.spongocoel.godseye;

import java.awt.Color;

public class ColorSpace {
    private Color[] colorArray;
    private static ColorSpace me = new ColorSpace();

    public static ColorSpace getInstance() {
        return me;
    }

    private ColorSpace() {
    }

    public void setColors(int numberOfGrays) {
        if (numberOfGrays < 2) {
            numberOfGrays = 2;
        }
        if (numberOfGrays > 255) {
            numberOfGrays = 255;
        }
        this.colorArray = new Color[numberOfGrays];
        double step = 255.0 / (double)(numberOfGrays - 1);
        double valueDouble = 255.0;
        int valueInt = 255;
        int i = 0;
        while (i < numberOfGrays) {
            Color newColor;
            valueInt = (int)Math.floor(valueDouble);
            if (valueInt < 0) {
                valueInt = 0;
            }
            this.colorArray[i] = newColor = new Color(valueInt, valueInt, valueInt);
            valueDouble -= step;
            ++i;
        }
    }

    public int getNumberOfGrays() {
        return this.colorArray.length;
    }

    public Color getNextColor(int last) {
        if (last >= this.colorArray.length - 1) {
            return this.colorArray[0];
        }
        return this.colorArray[last + 1];
    }
}

