/*
 * Decompiled with CFR 0.152.
 */
package com.spongocoel.godseye;

import com.spongocoel.godseye.App;
import com.spongocoel.godseye.ColorSpace;
import java.awt.Color;
import javax.swing.JPanel;

public class Pixel
extends JPanel {
    private Pixel child;
    private int currentColor = -1;

    public Pixel() {
        this.changeColor();
        this.setOpaque(true);
        this.setVisible(true);
    }

    public void reset() {
        this.currentColor = -1;
        this.changeColor();
        if (this.child != null) {
            this.child.reset();
        }
    }

    public void go() {
        if (this.child != null) {
            this.child.go();
        }
        while (this.currentColor < ColorSpace.getInstance().getNumberOfGrays() - 1) {
            if (this.child != null) {
                this.child.reset();
            }
            this.changeColor();
            try {
                Thread.sleep(App.DELAY);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.child == null) continue;
            this.child.go();
        }
    }

    public void changeColor() {
        Color nextColor = ColorSpace.getInstance().getNextColor(this.currentColor);
        this.setBackground(nextColor);
        ++this.currentColor;
    }

    public void setChild(Pixel c) {
        this.child = c;
    }

    public Pixel getChild() {
        return this.child;
    }
}

