/*
 * Decompiled with CFR 0.152.
 */
package com.spongocoel.godseye;

import com.spongocoel.godseye.Pixel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TheWindow
extends JFrame {
    public TheWindow(Pixel startPixel, int rows, int columns) {
        super("Every image of size " + rows + " by " + columns);
        Container cp = this.getContentPane();
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(rows, columns));
        panel.setBackground(Color.WHITE);
        panel.setBorder(BorderFactory.createMatteBorder(10, 10, 20, 10, Color.LIGHT_GRAY));
        cp.add(panel);
        Pixel pixel = startPixel;
        while (pixel != null) {
            panel.add(pixel);
            pixel = pixel.getChild();
        }
        int idealWidth = 640;
        int idealHeight = 480;
        int width = idealWidth;
        int height = idealHeight;
        int wfactor = idealWidth / columns;
        int hfactor = idealHeight / rows;
        if (wfactor < hfactor) {
            width = columns * wfactor;
            height = rows * wfactor;
        } else {
            width = columns * hfactor;
            height = rows * hfactor;
        }
        panel.setPreferredSize(new Dimension(width + 20, height + 30));
        this.pack();
        this.setLocation(50, 50);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        startPixel.go();
        this.setTitle("Done: Every image of size " + rows + " by " + columns);
    }
}

